package com.example.sefinsa_app.models;

import android.os.Build;

import java.util.HashMap;
import java.util.Map;

public class ReporteHistorial {
    private String tarjeton, nombre_completo, ruta_id, poblacion_id, grupo, modalidad_semanas, monto_prestado, pago_semanal, prestamo_id, cantidad_esperada_pago, cantidad_normal_pagada,
            cantidad_multa, cantidad_pendiente, cantidad_total_pagada, concepto, fecha_pago, fecha_pago_realizada,
            folio, semana, balance_original, empleado_id, status, recuperado, tipo_pago, pago_status, nombre_poblacion;

    private Map<Integer, String> detallesSemanas;

    public String getTarjeton() {
        return tarjeton;
    }

    public void setTarjeton(String tarjeton) {
        this.tarjeton = tarjeton;
    }

    public String getNombre_completo() {
        return nombre_completo;
    }

    public void setNombre_completo(String nombre_completo) {
        this.nombre_completo = nombre_completo;
    }

    public String getRuta_id() {
        return ruta_id;
    }

    public void setRuta_id(String ruta_id) {
        this.ruta_id = ruta_id;
    }

    public String getPoblacion_id() {
        return poblacion_id;
    }

    public void setPoblacion_id(String poblacion_id) {
        this.poblacion_id = poblacion_id;
    }

    public String getNombre_poblacion() {
        return nombre_poblacion;
    }

    public void setNombre_poblacion(String nombre_poblacion) {
        this.nombre_poblacion = nombre_poblacion;
    }

    public String getGrupo() {
        return grupo;
    }

    public void setGrupo(String grupo) {
        this.grupo = grupo;
    }

    public String getModalidad_semanas() {
        return modalidad_semanas;
    }

    public void setModalidad_semanas(String modalidad_semanas) {
        this.modalidad_semanas = modalidad_semanas;
    }

    public String getMonto_prestado() {
        return monto_prestado;
    }

    public void setMonto_prestado(String monto_prestado) {
        this.monto_prestado = monto_prestado;
    }

    public String getPago_semanal() {
        return pago_semanal;
    }

    public void setPago_semanal(String pago_semanal) {
        this.pago_semanal = pago_semanal;
    }

    public String getPrestamo_id() {
        return prestamo_id;
    }

    public void setPrestamo_id(String prestamo_id) {
        this.prestamo_id = prestamo_id;
    }

    public String getCantidad_esperada_pago() {
        return cantidad_esperada_pago;
    }

    public void setCantidad_esperada_pago(String cantidad_esperada_pago) {
        this.cantidad_esperada_pago = cantidad_esperada_pago;
    }

    public String getCantidad_normal_pagada() {
        return cantidad_normal_pagada;
    }

    public void setCantidad_normal_pagada(String cantidad_normal_pagada) {
        this.cantidad_normal_pagada = cantidad_normal_pagada;
    }

    public String getCantidad_multa() {
        return cantidad_multa;
    }

    public void setCantidad_multa(String cantidad_multa) {
        this.cantidad_multa = cantidad_multa;
    }

    public String getCantidad_pendiente() {
        return cantidad_pendiente;
    }

    public void setCantidad_pendiente(String cantidad_pendiente) {
        this.cantidad_pendiente = cantidad_pendiente;
    }

    public String getCantidad_total_pagada() {
        return cantidad_total_pagada;
    }

    public void setCantidad_total_pagada(String cantidad_total_pagada) {
        this.cantidad_total_pagada = cantidad_total_pagada;
    }

    public String getConcepto() {
        return concepto;
    }

    public void setConcepto(String concepto) {
        this.concepto = concepto;
    }

    public String getFecha_pago() {
        return fecha_pago;
    }

    public void setFecha_pago(String fecha_pago) {
        this.fecha_pago = fecha_pago;
    }

    public String getFecha_pago_realizada() {
        return fecha_pago_realizada;
    }

    public void setFecha_pago_realizada(String fecha_pago_realizada) {
        this.fecha_pago_realizada = fecha_pago_realizada;
    }

    public String getFolio() {
        return folio;
    }

    public void setFolio(String folio) {
        this.folio = folio;
    }

    public String getSemana() {
        return semana;
    }

    public void setSemana(String semana) {
        this.semana = semana;
    }

    public String getBalance_original() {
        return balance_original;
    }

    public void setBalance_original(String balance_original) {
        this.balance_original = balance_original;
    }

    public String getEmpleado_id() {
        return empleado_id;
    }

    public void setEmpleado_id(String empleado_id) {
        this.empleado_id = empleado_id;
    }
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getRecuperado() {
        return recuperado;
    }

    public void setRecuperado(String recuperado) {
        this.recuperado = recuperado;
    }

    public String getTipo_pago() {
        return tipo_pago;
    }

    public void setTipo_pago(String tipo_pago) {
        this.tipo_pago = tipo_pago;
    }

    public String getPago_status() {
        return pago_status;
    }

    public void setPago_status(String pago_status) {
        this.pago_status = pago_status;
    }

    // Método para establecer el detalle de una semana específica
    public void setDetalleSemana(int semana, String detalle) {
        if (detallesSemanas == null) {
            detallesSemanas = new HashMap<>(); // Inicializa si es necesario
        }
        detallesSemanas.put(semana, detalle); // Asigna el detalle al número de semana
    }


    // Método para obtener el detalle de una semana específica
    public String getDetalleSemana(int semana) {
        if (detallesSemanas.containsKey(semana)) {
            return detallesSemanas.get(semana);
        } else {
            return ""; // Valor predeterminado si no existe
        }
    }

    // Método para obtener todos los detalles de las semanas
    public Map<Integer, String> getDetallesSemanas() {
        return detallesSemanas;
    }
    public int getDetallesSemanasPagado(int semana) {
        if (detallesSemanas != null && detallesSemanas.containsKey(semana)) {
            String detalleSemana = detallesSemanas.get(semana);

            if (detalleSemana.contains("Pago a tiempo")) {
                return 1;  // Estado de pago a tiempo
            } else if (detalleSemana.contains("No pagó")) {
                return -1;  // Estado de no pagado
            } else if (detalleSemana.contains("Pago omitido")) {
                return 2;  // Estado de pago omitido
            } else if (detalleSemana.contains("Pago con multa")) {
                return 3;  // Estado de pago con multa
            } else {
                return 0;  // Estado gris si no se encuentra un estado específico
            }
        }
        return 0;  // Si no se encuentra el detalle, retornamos un estado gris (0)
    }

    public int getEstadoPagoSemana(int semana) {
        if (detallesSemanas != null && detallesSemanas.containsKey(semana)) {
            String detalleSemana = detallesSemanas.get(semana);

            if (detalleSemana.contains("Pago a tiempo")) {
                return 1;  // Estado de pago a tiempo
            } else if (detalleSemana.contains("No pagó")) {
                return -1;  // Estado de no pagado
            } else if (detalleSemana.contains("Pago omitido")) {
                return 2;  // Estado de pago omitido
            } else if (detalleSemana.contains("Pago con multa")) {
                return 3;  // Estado de pago con multa
            } else if (detalleSemana.contains("Pago vigente")) {
                return 0;  // Estado de pago con multa
            } else {
                return 4;  // Estado gris si no se encuentra un estado específico
            }
        }
        return 0;  // Si no se encuentra el detalle, retornamos un estado gris (0)
    }

}

